﻿<%@ Page Title="Patient Imaging" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="PatientImaging.aspx.cs" Inherits="PatientImaging" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<%@ Import  Namespace="System.Web.Security.AntiXss" %>

<asp:Content ID="ContentHead" ContentPlaceHolderID="head" runat="server">
    <link href="styles/Imaging.css" rel="stylesheet" />
</asp:Content>

<asp:Content ID="ContentMain" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    
    <telerik:RadScriptManager 
        runat="server" 
        ID="RadScriptManagerMain" 
        OnAsyncPostBackError="RadScriptManagerMain_AsyncPostBackError" 
        AllowCustomErrorsRedirect="false" />

    <telerik:RadCodeBlock ID="RadCodeBlockMain" runat="server">

        <script type="text/javascript">
            $(document).ready(function () {

                var jointSelection = $('#<%=RadComboBoxJointSpace.ClientID %>').val();
                if (jointSelection == 'Yes') {
                    $('#<%=RadTextBoxJoint.ClientID%>').prop('disabled', false);
                }

                var hasRecord = $('#<%=HiddenFieldHasHistory.ClientID%>').val();
                if (hasRecord) {
                    if (hasRecord > 0) {
                        $('#<%=DeleteButton.ClientID%>').prop('disabled', false);
                    } else {
                        $('#<%=DeleteButton.ClientID%>').prop('disabled', true);
                    }
                }

            }); // $(document).ready(function ()

            function RadComboBoxJointSpaceOnClientLoad(sender) {

                var item = sender.get_selectedItem();
                if (item) {
                    var text = item.get_text();

                    if (text.indexOf('Yes') !== -1) {
                    $('#<%=RadTextBoxJoint.ClientID%>').prop('disabled', false);
                    } else {
                        $('#<%=RadTextBoxJoint.ClientID%>').prop('disabled', true);
                        $('#<%=RadTextBoxJoint.ClientID%>').val('');
                    }
                } 
            }

            function RadComboBoxJointSpaceOnClientSelectedIndexChanged(sender, args) {

                var text = args.get_item().get_text();

                if (text.indexOf('Yes') !== -1) {
                    $('#<%=RadTextBoxJoint.ClientID%>').prop('disabled', false);
                } else {
                    $('#<%=RadTextBoxJoint.ClientID%>').prop('disabled', true);
                    $('#<%=RadTextBoxJoint.ClientID%>').val('');
                }
            }

            function RadComboBoxFragmentVerifiedSelectedIndexChanged(sender, args) {

                var text = args.get_item().get_text();

                if (text.indexOf('Select') == -1) {
                    dateVar = new Date();
                    var datepicker = $find("<%= RadDatePickerDateImagingReviewedByStaff.ClientID %>");
                    datepicker.set_selectedDate(dateVar);
                } 
            }

            function pageLoad(sender, eventArgs) {
                if (!eventArgs.get_isPartialLoad()) {
                    $find("<%= RadAjaxManagerImages.ClientID %>").ajaxRequest("InitialPageLoad");
                }
            }


            // *****************************************************************************************
            // AJAX Error Handling
            var divElem = 'AlertDiv';
            var messageElem = 'AlertMessage';
            var bodyTag = 'Errors';
            var alertButtons = 'AlertButtons';
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(EndRequestHandler);

            function ToggleAlertDiv(visString) {
                if (visString == 'hidden') {
                    $get(bodyTag).style.backgroundColor = 'white';
                }
                else {
                    $get(bodyTag).style.backgroundColor = 'gray';

                    $get(alertButtons).style.display = 'block';
                }
                var adiv = $get(divElem);
                adiv.style.visibility = visString;
            }

            function ClearErrorState() {
                $get(messageElem).innerHTML = '';
                ToggleAlertDiv('hidden');
            }

            function EndRequestHandler(sender, args) {
                if (args.get_error() != undefined) {
                    args.set_errorHandled(true);
                    ToggleAlertDiv('visible');

                    var message = args.get_error().message;
                    var components = message.split(": ");
                    if (components.length == 2) {
                        message = components[1];
                    }
                    $get(messageElem).innerHTML = message;
                }
            }

        </script>
    </telerik:RadCodeBlock>

    <div class="breadcrumb">
        <asp:Label runat="server" SkinID="DataLabel" ID="LabelBreadCrumb" Text="Patients > Patient Lookup > Imaging > " />
    </div> 

    <!-- ********************************************************************************************** -->
    <!-- Patient Information -->
    <!-- ******************* -->
  
        <div class="va-bold underline">
            <asp:Label runat="server" SkinID="DataLabel" ID = "LabelPatientInformation" Text="Patient Information" />
        </div>

        <table style="width:100%">
            <tr>
                <!-- Patient Name -->
                <td class="style1">
                    <asp:Label 
                        runat="server" 
                        ID="LabelPatientName" 
                        AssociatedControlID="LabelPatientNameData" 
                        SkinID="DataLabel"
                        Text="Patient Name:">
                    </asp:Label>
                </td>
                <td class="style2">
                    <asp:Label 
                        runat="server" 
                        ID="LabelPatientNameData" 
                        SkinID="DataLabel" >
                    </asp:Label>
                </td>
                <!-- Patient SSN -->
                <td class="style1" >
                    <asp:Label 
                        runat="server" 
                        ID="LabelPatientSsn" 
                        AssociatedControlID="LabelPatientSsnData" 
                        SkinID = "DataLabel"
                        Text="Patient SSN:">
                    </asp:Label>
                </td>
                <td class="style2" >
                        <asp:Label 
                            runat="server" 
                            ID="LabelPatientSsnData" 
                            SkinID="DataLabel" >
                        </asp:Label>
                </td>
            </tr>
            <tr>
                <!-- Date Imaging Reviewed by Staff -->
                <td class="style1">
                    <asp:Label 
                        runat="server" 
                        ID="Label1" 
                        AssociatedControlID="Label2" 
                        SkinID = "DataLabel"
                        Text="Date Imaging Reviewed by Staff:">
                    </asp:Label>
                </td>
                <td class="style2">
                    <asp:Label 
                        runat="server" 
                        ID="Label2" 
                        SkinID = "DataLabel" />
                </td>
                <!-- Fragment Verified -->
                <td class="style1">
                    <asp:Label 
                        runat="server" 
                        ID="Label3" 
                        AssociatedControlID="Label4" 
                        SkinID = "DataLabel"
                        Text="Fragment Verified:">
                    </asp:Label>
                </td>
                <td class="style2">
                    <asp:Label 
                        runat="server" 
                        ID="Label4" 
                        SkinID = "DataLabel" />
                </td>
            </tr>
        </table>
  

    <br />

    <!-- ********************************************************************************************** -->
    <!-- Images Fragments Summary -->
    <!-- ************************ -->
    <div class="va-boxed-content">
        <div class="va-bold underline">
            <asp:Label runat="server" SkinID="DataLabel" ID="LabelImagesFragmentSummary" Text="Images Fragments Summary" />
        </div>
        <br />

        <div>
            <!-- Are Images and/or Imaging Reports Available Within CPRS -->
            <div class="inline-left">
                <telerik:RadLabel 
                    runat="server"
                    ID="RadLabelImageType"
                    AssociatedControlID="RadComboBoxInCprs"
                    CssClass="label-image-details"
                    Text="Are Images and/or Imaging Reports Available Within CPRS: "
                    Width="500">
                </telerik:RadLabel>
                <telerik:RadComboBox 
                    runat="server"
                    role="application"
                    ID="RadComboBoxInCprs" 
                    RenderMode="Lightweight"
                    AccessibilityMode="true"
                    EnableAriaSupport="true"
                    AriaSettings-Label="Are Images and/or Imaging Reports Available Within CPRS"
                    Width="150">
                </telerik:RadComboBox>
            </div>

            <!-- Fragment Verified -->
            <div class="inline-right">
                <telerik:RadLabel 
                    runat="server"
                    ID="RadLabelFragmentVerified"
                    AssociatedControlID="RadComboBoxFragmentVerified"
                    CssClass="label-image-details"
                    Text="Fragment Verified: "
                    Width="400">
                </telerik:RadLabel>
                <telerik:RadComboBox
                    runat="server" 
                    role="application"
                    ID="RadComboBoxFragmentVerified" 
                    RenderMode="Lightweight"
                    AccessibilityMode="true"
                    EnableAriaSupport="true"
                    AriaSettings-Label="Fragment Verified"
                    Width="150"
                    OnClientSelectedIndexChanged="RadComboBoxFragmentVerifiedSelectedIndexChanged">
                </telerik:RadComboBox>
            </div>
        </div>
        <br />

        <div>
            <!-- Is There Documentation of a Bone Fracture -->
            <div class="inline-left">
                <telerik:RadLabel 
                    runat="server"
                    ID="RadLabelBoneFracture"
                    AssociatedControlID="RadComboBoxBoneFracture"
                    CssClass="label-image-details"
                    Text="Is There Documentation of a Bone Fracture: "
                    Width="500">
                </telerik:RadLabel>
                <telerik:RadComboBox 
                    runat="server"
                    role="application"
                    ID="RadComboBoxBoneFracture" 
                    RenderMode="Lightweight" 
                    AccessibilityMode="true"
                    EnableAriaSupport="true"
                    AriaSettings-Label="Is There Documentation of a Bone Fracture"
                    Width="150">
                </telerik:RadComboBox>
            </div>

            <!-- Are the Majority of Fragments Predominately -->
            <div class="inline-right">
                <telerik:RadLabel 
                    runat="server"
                    ID="RadLabelFragmentSize"
                    AssociatedControlID="RadComboBoxFragmentSize"
                    CssClass="label-image-details"
                    Text="Are the Majority of Fragments Predominately: "
                    Width="400">
                </telerik:RadLabel>
                <telerik:RadComboBox
                    runat="server" 
                    role="application"
                    ID="RadComboBoxFragmentSize" 
                    RenderMode="Lightweight"
                    AccessibilityMode="true"
                    EnableAriaSupport="true"
                    AriaSettings-Label="Are the Majority of Fragments Predominately"
                    Width="300">
                </telerik:RadComboBox>
            </div>
        </div>
        <br />

        <div>
            <!-- Are Any of the Fragments Located Within a Joint Space -->
            <div class="inline-left">
                <telerik:RadLabel 
                    runat="server"
                    ID="RadLabelJointSpace"
                    AssociatedControlID="RadComboBoxJointSpaceOnClientLoad"
                    CssClass="label-image-details"
                    Text="Are Any of the Fragments Located Within a Joint Space: "
                    Width="500">
                </telerik:RadLabel>
                <telerik:RadComboBox 
                    runat="server"
                    role="application"
                    ID="RadComboBoxJointSpace" 
                    RenderMode="Lightweight" 
                    AccessibilityMode="true"
                    EnableAriaSupport="true"
                    AriaSettings-Label="Are Any of the Fragments Located Within a Joint Space"
                    Width="150"
                    OnClientLoad="RadComboBoxJointSpaceOnClientLoad"
                    OnClientSelectedIndexChanged="RadComboBoxJointSpaceOnClientSelectedIndexChanged">
                </telerik:RadComboBox>
            </div>

            <!-- Joint -->
            <div class="inline-right">
                <telerik:RadLabel 
                    runat="server"
                    ID="RadLabelJoint"
                    AssociatedControlID="RadTextBoxJoint"
                    CssClass="label-image-details"
                    Text="Joint: "
                    Width="400">
                </telerik:RadLabel>
                <telerik:RadTextBox
                    runat="server" 
                    role="application"
                    ID="RadTextBoxJoint" 
                    RenderMode="Lightweight" 
                    AccessibilityMode="true"
                    EnableAriaSupport="true"
                    AriaSettings-Label="Joint"
                    TextMode="MultiLine"
                    Rows="3"
                    Width="500" 
                    EmptyMessage="Enter Joint Details">
                </telerik:RadTextBox>
            </div>
        </div>
        <br />

        <!-- Date Imaging Reviewed by Staff -->
        <div>
            <telerik:RadLabel 
                runat="server"
                ID="LabelDateImagingReviewedByStaff"
                AssociatedControlID="RadDatePickerDateImagingReviewedByStaff"
                CssClass="label-image-details"
                Text="Date Imaging Reviewed by Staff: "
                Width="500">
            </telerik:RadLabel>
            <telerik:RadDatePicker 
                runat="server"
                role="application"
                ID="RadDatePickerDateImagingReviewedByStaff"
                RenderMode="Lightweight" 
                AccessibilityMode="true"
                EnableAriaSupport="true"
                AriaSettings-Label="Date Imaging Reviewed by Staff"
                DateInput-EmptyMessage="mm/dd/yyyy"
                DateInput-ToolTip="mm/dd/yyyy">
                <Calendar ID="CalendarDateImagingReviewedByStaff" runat="server" />
            </telerik:RadDatePicker>
        </div>
        <br />

        <!-- Other Fragment Related Observations -->
        <div>
            <telerik:RadLabel 
                runat="server"
                ID="RadLabelComments"
                AssociatedControlID="RadTextBoxOtherObservations"
                CssClass="label-image-details"
                Text="Other Fragment Related Observations: "
                Width="500">
            </telerik:RadLabel>
        </div>
         <br />

        <div>
            <telerik:RadTextBox 
                runat="server" 
                role="application"
                ID="RadTextBoxOtherObservations" 
                RenderMode="Lightweight" 
                AccessibilityMode="true"
                EnableAriaSupport="true"
                AriaSettings-Label="Other Fragment Related Observations"
                TextMode="MultiLine"
                Rows="6"
                Width="100%" 
                EmptyMessage="Enter Other Fragment Related Observations">
            </telerik:RadTextBox>
        </div>

    </div>

    <!-- ********************************************************************************************** -->
    <!-- Buttons -->
    <!-- ******* -->
    <table width="100%">
        <tr>
            <td align="left">
                <asp:Button 
                    runat = "server" 
                    ID = "BackButton" 
                    Text = "Back" 
                    Width = "130px" 
                    OnClick="BackButton_Click"
                    UseSubmitBehavior = "false" 
                    CausesValidation="false"
                    ToolTip="Return to previous page."/>
                <asp:Button 
                    runat = "server" 
                    ID = "SaveButton" 
                    Text = "Save" 
                    Width = "130px" 
                    OnClick = "SaveButton_Click" 
                    UseSubmitBehavior = "true" 
                    ToolTip="Save entries." />
                <asp:Button 
                    runat = "server" 
                    ID = "DeleteButton" 
                    Text = "Delete" 
                    Width = "130px" 
                    OnClick = "DeleteButton_Click"
                    OnClientClick="return confirm('Are you certain you want to delete this record?');"
                    Disabled="disabled"
                    UseSubmitBehavior = "true" 
                    CausesValidation="false"
                    ToolTip="Delete record."/>
            </td>
        </tr>
    </table> 
    <br />

    <telerik:RadAjaxManager ID="RadAjaxManagerImages" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="RadAjaxManagerImages">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="PanelImages" LoadingPanelID="RadAjaxLoadingPanelImages" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="PanelImages">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="PanelImages" LoadingPanelID="RadAjaxLoadingPanelImages" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManager>

    <telerik:RadAjaxLoadingPanel ID="RadAjaxLoadingPanelImages" runat="server" Skin="Default" >
    </telerik:RadAjaxLoadingPanel>

    <div id="Messages" class="va-italic">
        <asp:Label runat="server" SkinID="DataLabel" ID ="LabelError" />
    </div>

    <div id="Errors">
        <div id="AlertDiv">
            <div id="AlertMessage">
            </div>
            <br />
            <div id="AlertButtons" style="display:none;">
                <button onclick="ClearErrorState();">OK</button>
            </div>
        </div>
    </div>

    <div class="va-bold underline">
        <asp:Label runat="server" SkinID="DataLabel" ID="LabelImages" Text="Images" />
    </div>

    <asp:Panel ID="PanelImages" runat="server" Height="400px">

        <telerik:RadGrid 
            runat="server" 
            ID="RadGridImages" 
            GridLines="None" 
            AutoGenerateColumns="false" 
            PageSize="10"
            AllowPaging="true" 
            AllowSorting="true" 
            AllowAutomaticUpdates="true" 
            ShowStatusBar="true"
            StatusBarSettings-LoadingText="Loading Images"
            OnNeedDataSource="RadGridImages_NeedDataSource">

            <MasterTableView 
                ShowFooter="false" 
                DataKeyNames="PATIENT_IMAGE_ID" 
                EditMode="InPlace" 
                ShowHeadersWhenNoRecords="true"
                NoMasterRecordsText="No imaging data available at this time.">

                <Columns>
                    <telerik:GridNumericColumn
                        Visible="false"
                        DataType="System.Int32"  
                        DataField="PATIENT_ID" 
                        HeaderText="PATIENT_ID" 
                        SortExpression="PATIENT_ID" 
                        UniqueName="PATIENT_ID" >
                    </telerik:GridNumericColumn>

                    <telerik:GridNumericColumn
                        Visible="false"
                        DataType="System.Int32"  
                        DataField="PATIENT_IMAGE_ID" 
                        HeaderText="PATIENT_IMAGE_ID" 
                        SortExpression="PATIENT_IMAGE_ID" 
                        UniqueName="PATIENT_IMAGE_ID" >
                    </telerik:GridNumericColumn>

                    <telerik:GridDateTimeColumn 
                        DataField="DATE_IMAGED" 
                        DataType="System.DateTime" 
                        DataFormatString="{0:MM/dd/yyyy}"  
                        HeaderText="Date Imaged" 
                        SortExpression="DateImaged" 
                        UniqueName="DateImaged"
                        ReadOnly="true">  
                    </telerik:GridDateTimeColumn>  

                    <telerik:GridTemplateColumn 
                        DataField="SYSTEM_IDENTIFIED_FRAGMENT"
                        DataType="System.String" 
                        HeaderText="System Identified" 
                        SortExpression="SystemIdentified" 
                        UniqueName="SystemIdentified"
                        ReadOnly="true">  
                        <ItemTemplate>
                            <%#AntiXssEncoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem, "SYSTEM_IDENTIFIED_FRAGMENT")), false)%>
                        </ItemTemplate>
                    </telerik:GridTemplateColumn> 

                    <telerik:GridTemplateColumn 
                        DataField="FRAGMENT_VERIFIED"
                        DataType="System.String" 
                        HeaderText="Fragment Verified" 
                        SortExpression="FragmentVerified" 
                        UniqueName="FragmentVerified"
                        ReadOnly="true">  
                        <ItemTemplate>
                            <%#AntiXssEncoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem, "FRAGMENT_VERIFIED")), false)%>
                        </ItemTemplate>
                    </telerik:GridTemplateColumn> 

                    <telerik:GridTemplateColumn 
                        DataField="REVIEWED"
                        DataType="System.String" 
                        HeaderText="Reviewed" 
                        SortExpression="Reviewed" 
                        UniqueName="Reviewed"
                        ReadOnly="true">  
                        <ItemTemplate>
                            <%#AntiXssEncoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem, "REVIEWED")), false)%>
                        </ItemTemplate>
                    </telerik:GridTemplateColumn> 

                    <telerik:GridTemplateColumn 
                        DataType="System.String" 
                        HeaderText="Body Part(s) Imaged" 
                        SortExpression="ImageBodyParts" 
                        UniqueName="ImageBodyParts"
                        ReadOnly="true">  
                        <ItemTemplate>
                            <%#AntiXssEncoder.HtmlEncode(GetBodyPartsImaged(DataBinder.Eval(Container.DataItem, "PATIENT_IMAGE_ID")), false)%>
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>

                    <telerik:GridTemplateColumn 
                        HeaderText="Image Fragment Count">
                        <ItemTemplate>
                            <%#AntiXssEncoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem, "IMAGE_FRAGMENT_COUNT_DESCRIPTION_TEXT")), false)%>
                        </ItemTemplate>
                        <EditItemTemplate>        
                            <telerik:RadComboBox 
                                runat="server" 
                                ID="RadComboBoxFragmentCount" 
                                DataTextField="DESCRIPTION_TEXT"
                                DataValueField ="ID" 
                                DataSourceID ="SqlDataSourceImageFragmentCount" 
                                SelectedValue='<%#Bind("STD_IMAGE_FRAGMENT_COUNT_ID") %>'>
                                <DefaultItem Text="" Value=""></DefaultItem>
                            </telerik:RadComboBox>
                        </EditItemTemplate>
                    </telerik:GridTemplateColumn>

                    <telerik:GridHyperLinkColumn 
                        DataTextFormatString="Viewer"
                        DataNavigateUrlFields="IMAGE_URL" 
                        UniqueName="ImageUrl" 
                        DataNavigateUrlFormatString=""
                        HeaderText="Image Url" 
                        DataTextField="IMAGE_URL"
                        Target="_blank">
                    </telerik:GridHyperLinkColumn>

                    <telerik:GridTemplateColumn 
                        AllowFiltering="false" 
                        UniqueName="Details"
                        HeaderText="Details">
                        <ItemTemplate>
                            <a href="PatientImageDetails.aspx?patientId=<%#AntiXssEncoder.UrlEncode(Convert.ToString(Eval("PATIENT_ID")))%>&patientImageId=<%#AntiXssEncoder.UrlEncode(Convert.ToString(Eval("PATIENT_IMAGE_ID")))%>"> 
                                View\Edit Details
                            </a>
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>

                </Columns>

            </MasterTableView>

        </telerik:RadGrid>           

    </asp:Panel> 

    <!-- ************ -->
    <!-- Data Sources -->

    <asp:SqlDataSource 
        ID="SqlDataSourceImageFragmentCount" 
        runat="server" 
        ConnectionString="<%$ ConnectionStrings:RegistryConnectionString %>" 
        SelectCommand="[EFR].[usp_GetStandardFragmentCount]"      
        SelectCommandType="StoredProcedure">
    </asp:SqlDataSource>

        
    <!-- ********************************************************************************************** -->
    <!-- Other -->
    <asp:HiddenField runat="server" ID="PageSaveCount" Value="0"/>
    <asp:HiddenField runat="server" ID="HiddenFieldHasHistory" Value="0"/>

</asp:Content>
